/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.monitor;

import com.ibm.hwmca.base.monitor.MonitorUtils;
import com.ibm.hwmca.base.monitor.ObjectWrapper;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class DumpTraceBuf {
    private static final String TRACE_MASKD = "XMONDTBD";
    private static final String TRACE_MASKF = "XMONDTBF";
    private static final String TRACE_MASKT = "XMONDTBT";
    private static final String ALL_PIDS_ARG = "all";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_INVALID_PID = 1;
    private static final int EXIT_INCORRECT_NUM_OF_ARGS = 2;
    private static final int EXIT_NO_PIDS = 3;
    private static final int EXIT_CMD_FAILED = 4;
    private static final int EXIT_NO_LIB_NAME = 5;
    private static final String TRACE_LIB = "libiqzdtrac.so";
    private static final String INIT_PID = "1";
    private static final long SHOW_TRACE_TIMEOUT = 20000L;
    private HashMap pIDMap;

    public static void main(String[] args) {
        int exitStatus = 0;
        StringBuffer argsLine = null;
        try {
            argsLine = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                argsLine.append(' ');
                argsLine.append(args[i]);
            }
            Trace.trace(TRACE_MASKT, "main() called with the following parameters :" + argsLine.toString());
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase(ALL_PIDS_ARG)) {
                    exitStatus = new DumpTraceBuf().displayAll();
                } else {
                    try {
                        exitStatus = DumpTraceBuf.display(Integer.parseInt(args[0]));
                    }
                    catch (NumberFormatException e) {
                        DumpTraceBuf.displayHelp();
                        exitStatus = 1;
                    }
                }
            } else {
                DumpTraceBuf.displayHelp();
                exitStatus = 2;
            }
            System.exit(exitStatus);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private int displayAll() {
        String[] command = null;
        ObjectWrapper stdOut = null;
        int commandRC = 0;
        String[] lines = null;
        int result = 0;
        String mapFileAndRange = null;
        String pID = null;
        String libName = null;
        Trace.trace(TRACE_MASKT, "->displayAll()");
        command = new String[]{"/bin/bash", "-c", "find /proc/ -type f -name 'maps' -print  | xargs grep -m 1 'libiqzdtrac.so'"};
        stdOut = new ObjectWrapper();
        commandRC = MonitorUtils.execute(command, stdOut, null);
        if (commandRC == 0 && stdOut.getObject() != null) {
            lines = MonitorUtils.getLines((String)stdOut.getObject());
            if (lines != null && lines.length > 0) {
                for (int i = 0; i < lines.length; ++i) {
                    mapFileAndRange = MonitorUtils.getWordX(lines[i], 1);
                    if (mapFileAndRange == null || (pID = MonitorUtils.getTokenX(mapFileAndRange, 2, "/")) == null || !this.doDisplay(pID) || (libName = MonitorUtils.getWordXFromRight(lines[i], 1)) == null) continue;
                    System.out.println("");
                    System.out.println("Process trace buffer for PID " + pID + " (" + this.getExecutable(pID) + ") :");
                    System.out.println("");
                    command = new String[]{"/bin/bash", "-c", "showTrace " + pID + " " + libName};
                    try {
                        CertUtils.executeCommand(command, null, true, false, true, false, true, 20000L);
                    }
                    catch (HException e) {
                        System.out.println(" Not available.");
                    }
                    System.out.println("");
                }
            } else {
                result = 3;
            }
        } else {
            result = 4;
        }
        Trace.trace(TRACE_MASKT, "<-displayAll() returned " + result);
        return result;
    }

    private static int display(int pID) {
        String[] command = null;
        ObjectWrapper stdOut = null;
        int result = 0;
        String libName = null;
        int commandRC = 0;
        Trace.trace(TRACE_MASKT, "->display(" + pID + ")");
        command = new String[]{"/bin/bash", "-c", "grep --no-filename 'libiqzdtrac.so' /proc/" + pID + "/maps"};
        stdOut = new ObjectWrapper();
        commandRC = MonitorUtils.execute(command, stdOut, null);
        if (commandRC == 0 && stdOut.getObject() != null) {
            libName = MonitorUtils.getWordX((String)stdOut.getObject(), 6);
            if (libName != null) {
                System.out.println("Process trace buffer for PID " + pID + ":");
                command = new String[]{"/bin/bash", "-c", "showTrace " + pID + " " + libName};
                try {
                    CertUtils.executeCommand(command, null, true, false, true, false, true, 20000L);
                }
                catch (HException e) {
                    System.out.println(" Not available.");
                }
            } else {
                result = 5;
            }
        } else {
            result = 4;
        }
        Trace.trace(TRACE_MASKT, "<-display() returned " + result);
        return result;
    }

    private static void displayHelp() {
        System.out.println("Show the process trace buffer for one or more processes.");
        System.out.println("");
        System.out.println("Usage: showTraceBuf + {pid | \"all\"}");
        System.out.println("");
        System.out.println("       where pid specifies the process for which the process trace buffer is");
        System.out.println("       to be dumped and \"all\" specifies that all processes that");
        System.out.println("       are using the trace library, libiqzdtrac.so, will be dumped.");
        System.out.println("");
        System.out.println("       Note, all must be specified without the double quotes.");
        System.out.println("       The process trace buffer is written to standard out (stdout).");
        System.out.println("");
    }

    private boolean doDisplay(String pID) {
        PIDEntry curEntry = null;
        boolean result = false;
        PIDEntry parentEntry = null;
        String parent = null;
        if (this.pIDMap == null) {
            this.initPIDs();
        }
        if (this.pIDMap != null && pID != null) {
            curEntry = (PIDEntry)this.pIDMap.get(pID);
            if (curEntry != null) {
                if (curEntry.getExecutable().indexOf("DumpTraceBuf") == -1) {
                    parent = curEntry.getParent();
                    if (!INIT_PID.equals(parent)) {
                        parentEntry = (PIDEntry)this.pIDMap.get(parent);
                        if (parentEntry != null) {
                            if (!curEntry.getExecutable().equals(parentEntry.getExecutable())) {
                                result = true;
                            }
                        } else {
                            result = true;
                        }
                    } else {
                        result = true;
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "could not find PID entry, for PID " + pID);
            }
        } else if (this.pIDMap == null) {
            Trace.trace(TRACE_MASKF, "pIDMap is null");
        }
        return result;
    }

    private void initPIDs() {
        String[] command = null;
        ObjectWrapper stdOut = null;
        int commandRC = 0;
        String[] lines = null;
        String pID = null;
        String pPID = null;
        HashMap<String, PIDEntry> stagingMap = null;
        int executableIndex = 0;
        PIDEntry pIDEntry = null;
        command = new String[]{"/bin/bash", "-c", "ps -eww --no-headers -o pid,ppid,args"};
        stdOut = new ObjectWrapper();
        commandRC = MonitorUtils.execute(command, stdOut, null);
        if (commandRC == 0 && stdOut.getObject() != null && (lines = MonitorUtils.getLines((String)stdOut.getObject())) != null && lines.length > 0) {
            stagingMap = new HashMap<String, PIDEntry>();
            for (int i = 0; i < lines.length; ++i) {
                pID = MonitorUtils.getWordX(lines[i], 1);
                if (pID == null || (pPID = MonitorUtils.getWordX(lines[i], 2)) == null || (executableIndex = MonitorUtils.getIndexWordX(lines[i], 3)) == -1) continue;
                try {
                    pIDEntry = new PIDEntry(pPID, lines[i].substring(executableIndex));
                    stagingMap.put(pID, pIDEntry);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (stagingMap.size() > 0) {
                this.pIDMap = stagingMap;
            }
        }
    }

    private String getExecutable(String pID) {
        String result = null;
        PIDEntry entry = null;
        result = "";
        if (this.pIDMap != null && pID != null) {
            try {
                entry = (PIDEntry)this.pIDMap.get(pID);
                if (entry != null && entry.getExecutable() != null) {
                    result = entry.getExecutable();
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private class PIDEntry {
        String parent;
        String executable;

        private PIDEntry(String parent, String executable) {
            if (parent == null || executable == null) {
                throw new IllegalArgumentException();
            }
            this.parent = parent;
            this.executable = executable;
        }

        private String getParent() {
            return this.parent;
        }

        private String getExecutable() {
            return this.executable;
        }

        public String toString() {
            return "PIDEntry(" + this.parent + ", " + this.executable + ")";
        }
    }
}

